package w83b.w83bOperacionesPaso.w83bResultados;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.contrib.HSSFRegionUtil;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaResulPorSectorSindicatoExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bResulPorSectorSindicato.xls";
		InputStream inputStream = W83bTablaReprCandTamEmpExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        Map resultados = (HashMap)contexto.get("w83bMapResultadosBean");
        W83bResultadosBean resultadoBean = (W83bResultadosBean)contexto.get("w83bResultadosBean");

        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
        
       
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        HashMap datosDelDep=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);
	   
        HSSFRow row;
        HSSFCell cell;
 
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)5);
        
        StringBuffer tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDepEs");
        StringBuffer tituloImagenEu =  (StringBuffer)datosDelDep.get("tituloDepEu");
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDelelegacionEs");
        tituloImagenEu = (StringBuffer)datosDelDep.get("tituloDelelegacionEu");
       
        row = sheet.getRow((short)10); 
        cell = row.createCell((short)5); 
       
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaHistorico())){
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));
    	}
       
        row = sheet.getRow((short)11); 
       
        cell = row.getCell((short)3); 
        if(StringUtils.isNotEmpty(resultadoBean.getDescTerritorio()))
        		{
        			cell.setCellValue(resultadoBean.getDescTerritorio().toUpperCase());
        		}else{
        			sheet.addMergedRegion(new Region(W83bClsConstantes.ONCE,Short.parseShort("3"),W83bClsConstantes.ONCE,Short.parseShort("5")));//NOPMD
        			 cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.comautvascaentero",idioma).toUpperCase()));
        		}
       
     
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        
        row = sheet.getRow((short)12); 
      
        cell = row.getCell((short)3); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionDesde())){
        	cell.setCellValue(resultadoBean.getFechaEleccionDesde());
        }
 
        cell = row.getCell((short)6); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionHasta())){
        	cell.setCellValue(resultadoBean.getFechaEleccionHasta());
        }
        cell = row.getCell((short)10); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaRegistroDefinitivo())){
        	cell.setCellValue(resultadoBean.getFechaRegistroDefinitivo());
        }
        cell = row.getCell((short)12); 
        if(StringUtils.isNotEmpty(resultadoBean.getSector())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("12"),W83bClsConstantes.DOCE,Short.parseShort("13")));//NOPMD
        	cell.setCellValue(resultadoBean.getSectorTxt());
        }else{
        	cell.setCellValue("");
        }
        		
        List totales=new ArrayList();
        if(null!=resultados.get("totales")){
        	totales=(ArrayList)resultados.get("totales");
        	resultados.remove("totales");
        }
        
        Map mapResultadosOrdenado = new TreeMap(resultados);
        Set ref = mapResultadosOrdenado.keySet();
        
        int inicioRepeticion=14;
   	 
	
	  int lineaactual=inicioRepeticion;
	  HashMap datos;
	 
	  Map mapSindicatosOrdenado;
	  Map sindicatos;
	  HashMap datosSinditato;
	  Iterator itSindicatos;
	  Iterator it=ref.iterator();
	  SortedMap  sindiref;
	  Region  region;
	  String key;
	  String keySindi;
	  boolean vacio=true;
	  int tamaoTabla;
	  int hoja=1;
	  String hombres="";
 	  String mujeres="";
 	  String divisor="";
       for(int i=0;it.hasNext();i++)
       {
    	   vacio=false;
    	  
    	   key=(String)it.next();
    	   datos=(HashMap)mapResultadosOrdenado.get(key);
    	   sindicatos=(HashMap)datos.get("datosSindicatos");
   	  	   mapSindicatosOrdenado= new TreeMap(sindicatos);//NOPMD
   	  	
   	  	 
   	  	   // La tabla va a tener cabecera de 
   	  	   //1 row SECTOR
   	  	   //+ 1 row separador+1 row cabeceras
   	       //+ 1row de separador
   	  	   //+ 1row de totales CABECERA LATERAL
   	  	   //+ 1row de totales DATOS
   	  	   //+ n row sindicatos 
   	  	   tamaoTabla=7+mapSindicatosOrdenado.size();
   	  	  //tenemos que mirar que si no entra deberemos de saltar.
   	  	  //La primera pagina tiene 50 lineas, entonces si nuestra tabla no supera esas lineas todo sigue su curso normal
   	  	   // sin embargo si supera controlaremos en que hoja se encuentra, para asignar a linea actual la primera linea de la siguiente hoja
   	  	   // primera pagina 50
   	  	   //siguentes paginas 34
   	  	   if(1!=hoja&&lineaactual+1+tamaoTabla> 50+((hoja-1)*36))
   	  		   {
   	  			  
   	  			   lineaactual=50+(36*(hoja-1));
   	  			  hoja++;
   	  		   }
   	  		   
   	 
   	  	   if(i!=0)
	  	   {
	  		   
	  		   excel.copyRow(wb, sheet,  inicioRepeticion+1,  lineaactual+1);
	      		excel.copyRow(wb, sheet,  inicioRepeticion+2,  lineaactual+2);
	      		excel.copyRow(wb, sheet,  inicioRepeticion+3,  lineaactual+3);
	      		excel.copyRow(wb, sheet,  inicioRepeticion+4,  lineaactual+4);
	  	   }
     		row = sheet.createRow((short)lineaactual+1); 
     		cell=row.createCell((short)1);
     		cell.setCellStyle(excel.styleNegrita);
     		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.sector",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+" / "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.sector",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": "));

     		cell=row.createCell((short)4);
     		if(StringUtils.isNotEmpty((String)datos.get("descsector"))){
     			cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel((String)datos.get("descsector")));
     		}

     		lineaactual=lineaactual+5;
        	
    	  	
    	  	sindiref = new	TreeMap(java.util.Collections.reverseOrder());//NOPMD
    	  	
    	  	sindiref.putAll(mapSindicatosOrdenado);
    	  	
    	  	//se ordena al reves pq me interesa
    	  	itSindicatos = sindiref.keySet().iterator();
    	  	            
    	  	for(int j=0;itSindicatos.hasNext();j++)
    	       {
    	    	   keySindi=(String)itSindicatos.next();
    	    	   datosSinditato=(HashMap)mapSindicatosOrdenado.get(keySindi);
    	    	   
    	    	  
    	    	   row = sheet.createRow((short)lineaactual); 
    	    	   sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("1"),lineaactual,Short.parseShort("5")));//NOPMD
    	     		 sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("6"),lineaactual,Short.parseShort("8")));//NOPMD
    	     		 sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("13"),lineaactual,Short.parseShort("14")));//NOPMD
	       	  		cell=row.createCell((short)1);	
	       	  		if(W83bClsConstantes.CONSTANTE_EUSKARA.equals(idioma))
	       	  		{
	       	  			if(StringUtils.isNotEmpty((String)datosSinditato.get("sinddese"))){
	       	  				cell.setCellValue((String)datosSinditato.get("sinddese"));
	       	  			}
	       	  		}else{
		       	  		if(StringUtils.isNotEmpty((String)datosSinditato.get("sinddesc"))){
	       	  				cell.setCellValue((String)datosSinditato.get("sinddesc"));
	       	  			}
	       	  			
	       	  		}
	       	  		
	       	  	    
	       	  	    
		       	  	cell=row.createCell((short)6);
		       	  	if(StringUtils.isNotEmpty((String)datosSinditato.get("siglas"))){
		       	  		cell.setCellValue((String)datosSinditato.get("siglas"));
		       	  	}
		       		
		       		hombres=(String)datosSinditato.get("numdelegadosh");
		       	  	mujeres=(String)datosSinditato.get("numdelegadosm");
		       	  	divisor=(String)datosSinditato.get("divisor");
	       	  		
		       	  	cell=row.createCell((short)9);
		       		cell.setCellStyle(styleCentradoNumeroFormateado(excel));
		       		if(StringUtils.isNotEmpty(hombres)){
		       			cell.setCellValue(W83bUtilidades.numero(hombres));
		       		}
		       	  	cell=row.createCell((short)10);
		       		
	       	  		cell.setCellValue(W83bUtilidades.porcentaje(Integer.parseInt(hombres), Integer.parseInt(divisor)));
	       	  		cell.setCellStyle(stylePorcentajesDcha(excel));
	       	  		
		       	  	cell=row.createCell((short)11);
		       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
		       		if(StringUtils.isNotEmpty(mujeres)){
		       			cell.setCellValue(W83bUtilidades.numero(mujeres));
		       		}
	       	  		
		       	  	cell=row.createCell((short)12);
		       	  	cell.setCellValue(W83bUtilidades.porcentaje(Integer.parseInt(mujeres), Integer.parseInt(divisor)));
	       	  		cell.setCellStyle(stylePorcentajesDcha(excel));
	       	  		
		       	 	cell=row.createCell((short)13);
		       	 	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
		       		if(StringUtils.isNotEmpty((String)datosSinditato.get("numdelegados"))){
		       			cell.setCellValue(W83bUtilidades.numero((String)datosSinditato.get("numdelegados")));
		       		}
		       	  	cell=row.createCell((short)14);
		       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
				       	  		
		       	  	
	       	  		if(j==0)
	       	  		{
	       	  		  region = new Region(lineaactual,(short)1,lineaactual,(short)14);//NOPMD
	       	  		  HSSFRegionUtil.setBorderTop((short)1, region, sheet, wb);
	                  HSSFRegionUtil.setTopBorderColor((short)0, region, sheet, wb);
	       	  		}
	       	  		lineaactual++;
    	       }
    	  	lineaactual++;
    	  	 row = sheet.createRow((short)lineaactual); 
    	  	 sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("1"),lineaactual,Short.parseShort("14")));//NOPMD
    	  	 cell=row.createCell((short)1);
    	  	 cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.totalSector",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+" / "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.totalSector",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": ");
    	  	 lineaactual++;
    	       row = sheet.createRow((short)lineaactual); 
	    	   sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("1"),lineaactual,Short.parseShort("5")));//NOPMD
	     		 sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("6"),lineaactual,Short.parseShort("8")));//NOPMD
	     		 sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("13"),lineaactual,Short.parseShort("14")));//NOPMD
	     		 
	     		hombres=(String)datos.get("numdelegadosh");
	       	  	mujeres=(String)datos.get("numdelegadosm");
	       	  	divisor=(String)datos.get("divisor");
	       	  	
	       	  	cell=row.createCell((short)9);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	       		if(StringUtils.isNotEmpty(hombres)){
	       			cell.setCellValue(W83bUtilidades.numero(hombres));
	       		}
       	  		
	       	  	cell=row.createCell((short)10);
	       	  	
       	  		cell.setCellValue(W83bUtilidades.porcentaje(Integer.parseInt(hombres),Integer.parseInt(divisor)));
       	  		cell.setCellStyle(stylePorcentajesDcha(excel));
       	  		
	       	  	cell=row.createCell((short)11);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	       		if(StringUtils.isNotEmpty(mujeres)){
	       			cell.setCellValue(W83bUtilidades.numero(mujeres));
	       		}
       	  		
	       	  	cell=row.createCell((short)12);
	       		cell.setCellValue(W83bUtilidades.porcentaje(Integer.parseInt(mujeres),Integer.parseInt(divisor)));
       	  		cell.setCellStyle(stylePorcentajesDcha(excel));
       	  		
	       	 	cell=row.createCell((short)13);
	       	 	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	       		if(StringUtils.isNotEmpty((String)datos.get("numdelegados"))){
	       			cell.setCellValue(W83bUtilidades.numero((String)datos.get("numdelegados")));
	       		}
	       	  	cell=row.createCell((short)14);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	       		
	       	 region = new Region(lineaactual-1,(short)1,lineaactual-1,(short)14);//NOPMD
          	 HSSFRegionUtil.setBorderBottom((short)1, region, sheet, wb);
               HSSFRegionUtil.setBottomBorderColor((short)0, region, sheet, wb);
    	    
      	  		lineaactual=lineaactual+1;
      
            
    	
	       if(vacio)
	       {
	    	   sheet.shiftRows(lineaactual+1,lineaactual+3, -4);
	       }
       }
       List totalesOrdenar=new ArrayList();
       if(null!=totales&&!totales.isEmpty()){
	    	   
    	   W83bResultadosBean total=new W83bResultadosBean();
    	   //Collections.sort(totales,Collections.reverseOrder());//la ordenamos de mayor a menor
    	   for(int p=0;p<totales.size();p++){
    		   
    		   total=(W83bResultadosBean)totales.get(p);
    		   totalesOrdenar.add(W83bUtilidades.rellenarCaracter(total.getNumdelegados(), "0", 6, true)+"|"+total.getSinddese()+"|"+total.getSinddesc()+"|"+total.getSiglas()+"|"+total.getNumdelegadosH()+"|"+total.getNumTrabajadores()+"|"+total.getNumdelegadosM());
    	   }
       }
       Collections.sort(totalesOrdenar,Collections.reverseOrder());//la ordenamos de mayor a menor
       if(null!=totalesOrdenar&&!totalesOrdenar.isEmpty()){
    	  excel.copyRow(wb, sheet,  inicioRepeticion+1,  lineaactual+1);
    	  excel.copyRow(wb, sheet,  inicioRepeticion+2,  lineaactual+2);
    	  excel.copyRow(wb, sheet,  inicioRepeticion+3,  lineaactual+3);
    	  excel.copyRow(wb, sheet,  inicioRepeticion+4,  lineaactual+4);
 	   
			row = sheet.createRow((short)lineaactual+1); 
			cell=row.createCell((short)1);
			cell.setCellStyle(excel.styleNegrita);
			if(StringUtils.isNotEmpty(resultadoBean.getTerritorio())){
				cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalterritorio",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+" / "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalterritorio",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": "));
			}else{
				cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalcomunidad",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+" / "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalcomunidad",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": "));				
			}
			int muj=0;
			int hom=0;
			int tot=0;
			lineaactual=lineaactual+5;
	    	   
    	   for(int p=0;p<totalesOrdenar.size();p++){
    		   
    		   String totalordenar=(String)totalesOrdenar.get(p);
    		   String[] to=(String[])totalordenar.split("\\|");
    		   
    		   row = sheet.createRow((short)lineaactual); 
	    	    
    		   cell=row.createCell((short)1);
       	  	   sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("1"),lineaactual,Short.parseShort("5")));//NOPMD
       	  		if(W83bClsConstantes.CONSTANTE_EUSKARA.equals(idioma))
       	  		{
       	  			if(StringUtils.isNotEmpty(to[1])){
       	  				cell.setCellValue(to[1]);
       	  			}
       	  		}else{
       	  			if(StringUtils.isNotEmpty(to[2])){
       	  				cell.setCellValue(to[2]);
       	  			}
       	  			
       	  		}
       	  		
       	  		cell=row.createCell((short)6);
	       	  	sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("6"),lineaactual,Short.parseShort("8")));//NOPMD
	       	  	if(StringUtils.isNotEmpty(to[3])){
	       	  		cell.setCellValue(to[3]);
	       	  	}
	       		
	       		cell=row.createCell((short)9);
	       		cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	       		if(StringUtils.isNotEmpty(to[4])){
	       			cell.setCellValue(W83bUtilidades.numero(to[4]));
	       		}
       	  		hom=hom+W83bUtilidades.numero(to[4]);
	       	  	cell=row.createCell((short)10);
	       		cell.setCellValue(W83bUtilidades.porcentaje(Integer.parseInt(to[4]), Integer.parseInt(to[5])));
       	  		cell.setCellStyle(stylePorcentajesDcha(excel));
       	  		
	       	  	cell=row.createCell((short)11);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	       		if(StringUtils.isNotEmpty(to[6])){
	       			cell.setCellValue(to[6]);
	       		}
       	  		muj=muj+W83bUtilidades.numero(to[6]);
	       	  	cell=row.createCell((short)12);
	       	  	cell.setCellValue(W83bUtilidades.porcentaje(Integer.parseInt(to[6]), Integer.parseInt(to[5])));
       	  		cell.setCellStyle(stylePorcentajesDcha(excel));
       	  		
	       	 	cell=row.createCell((short)13);
	       	 	sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("13"),lineaactual,Short.parseShort("14")));//NOPMD
	       	 	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	       		if(StringUtils.isNotEmpty(to[0])){
	       			cell.setCellValue(W83bUtilidades.numero(to[0]));
	       		}
       	  		tot=tot+W83bUtilidades.numero(to[0]);
	       	  	cell=row.createCell((short)14);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
			       	  		
	       	  	
       	  		if(p==0)
       	  		{
       	  		  region = new Region(lineaactual,(short)1,lineaactual,(short)14);//NOPMD
       	  		  HSSFRegionUtil.setBorderTop((short)1, region, sheet, wb);
                  HSSFRegionUtil.setTopBorderColor((short)0, region, sheet, wb);
       	  		}
       	  	lineaactual=lineaactual+1;
    	   }
    	    lineaactual++;
    	    row = sheet.createRow((short)lineaactual); 
  	  	 	sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("1"),lineaactual,Short.parseShort("14")));//NOPMD
  	  	 	cell=row.createCell((short)1);
		  	if(StringUtils.isNotEmpty(resultadoBean.getTerritorio())){
				cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalterritorio",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+" / "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalterritorio",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": ");
			}else{
				cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalcomunidad",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+" / "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalcomunidad",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": ");
			}
  	  	 	
  	  	 	lineaactual++;
  	  	 	row = sheet.createRow((short)lineaactual); 
	    	sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("1"),lineaactual,Short.parseShort("5")));//NOPMD
	     	sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("6"),lineaactual,Short.parseShort("8")));//NOPMD
	     	sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("13"),lineaactual,Short.parseShort("14")));//NOPMD
	     		 
	     		cell=row.createCell((short)9);
	     		cell.setCellStyle(styleCentradoNumeroFormateado(excel));
     	  		cell.setCellValue(hom);
     	  		
	       	  	cell=row.createCell((short)10);
	       	  	cell.setCellValue(W83bUtilidades.porcentaje(hom,tot));
     	  		cell.setCellStyle(stylePorcentajesDcha(excel));
     	  		
	       	  	cell=row.createCell((short)11);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
     	  		cell.setCellValue(muj);
     	  		
	       	  	cell=row.createCell((short)12);
	       		cell.setCellValue(W83bUtilidades.porcentaje(muj,tot));
     	  		cell.setCellStyle(stylePorcentajesDcha(excel));
     	  		
	       	 	cell=row.createCell((short)13);
	       	 	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
     	  		cell.setCellValue(tot);
	       	  	cell=row.createCell((short)14);
	       	  	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	       		//linea bajo el titulo
	       		region = new Region(lineaactual-1,(short)1,lineaactual-1,(short)14);//NOPMD
	          	HSSFRegionUtil.setBorderBottom((short)1, region, sheet, wb);
	            HSSFRegionUtil.setBottomBorderColor((short)0, region, sheet, wb);
	            //fin linea
	    	    lineaactual=lineaactual+1;
       }
       
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoResultadosPorSectorSindicato.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	private HSSFCellStyle stylePorcentajesDcha(W83bUtilidadesExcel excel){
		return excel.stylePorcentajesDcha;			
		
	}
	
	private HSSFCellStyle styleCentradoNumeroFormateado(W83bUtilidadesExcel excel){
		return excel.styleCentradoNumeroFormateado;			
		
	}
}
